/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.recipes.StatueLootList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FloodStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);

    public FloodStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60918_(SoundType.f_56742_));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }

    @Override
    public void executeStatueBehavior(StatueBlockEntity blockEntity, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        Vec3 hitPos = result.m_82450_();
        blockEntity.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
        blockEntity.floodBehavior(playerIn, pos, handIn, (float)hitPos.f_82479_, (float)hitPos.f_82480_, (float)hitPos.f_82481_);
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.f_12503_;
    }

    @Override
    public String getLootName() {
        return "flood";
    }

    @Override
    public boolean isHiddenStatue() {
        return true;
    }
}

